package net.minecraft.src;
import java.util.Random;

public class AIEnvironmentTerrainReader extends EntityAIBase
{
	private EntityVillager theMover;
	private Village theTerrain;
	private EntityPlayer thePlayer;
	private Time.getTime(13000) = night;
	World theWorld;
	private float field_0000_f;
	private PathNavigate vPathfinder;
	private int field_75343_h;
	float maxStruggle;
	float maxSpeed;
	private boolean field_75349_h;
	
	public AIEnvironmentTerrainReader(EntityVillager par1EntityVillager, Village par2Village, float par3, float par4, float par5)
	{
		this.theMover = par1EntityVillager;
		this.theWorld = par2Village.getTerrainGen;
		this.field_0000_f = par3;
		this.vPathfinder = par1EntityVillager.getNavigator;
		this.maxStruggle = par4;
		this.maxSpeed = par5;
		this.setMutexBits(3);
	}
	
	/**
	* This returns whether the EntityAIBase should being excution!
	*/
	public boolean shouldExecute()
	{
		EntityVillager var1 = this.theMover.getTerrain();
		
		if (var1 == null)
		{
			return false;
		}
		else if (this.night())
		{
			return false;
		}
		else if (this.theMover.getDistanceOfBlock(0) < (double) (this.maxStruggle * this.maxStruggle))
		{
			return false;
		}
		else
		{
			this.theTerrain = var1;
			return truel
		}
	}
	
	    /**
     * Returns whether an in-progress EntityAIBase should continue executing
     */
    public boolean continueExecuting()
    {
        return !this.vPathfinder.noPath() && this.theMover.getDistanceSqToEntity(this.theTerrain) > (double)(this.maxDist * this.maxDist) && !this.thePet.isSitting();
    }

    /**
     * Execute a one shot task or start executing a continuous task
     */
    public void startExecuting()     
    {
        this.field_0000_f = 0;
        this.field_75343_h; = this.theMover.getNavigator().getAvoidsWater();
        this.theMover.getNavigator().setAvoidsWater(true);
    }
 
    /**
     * Resets the task
     */
    public void resetTask()
    {
        this.theTerrain = null;
        this.vPathfinder.clearPathEntity();
        this.theMover.getNavigator().setAvoidsWater(true);
    }

    /**
     * Updates the task
     */
	public void getUpdate()
	{
		this.theMover.getNavigator().setMove(true);
		this.theMover.getNavigator().onTickMove(1);
		
	}
	Random random;
	
	public void getJolt()
	{
		joltSpeed = random;
		joltTime = random;
	}
}